-- make the covers for both players.
-- based off of the old screen filter code. this could stand to be rewritten.

local coverFile;
if ReadFile("Themes/moonlight/Graphics/_gameplay covers/setting.cfg") then
	coverFile = tostring( ReadFile("Themes/moonlight/Graphics/_gameplay covers/setting.cfg") );
else
	coverFile = "default";
end;

local IsUsingSoloSingles = PREFSMAN:GetPreference('Center1Player');
local NumPlayers = GAMESTATE:GetNumPlayersEnabled();
local NumSides = GAMESTATE:GetNumSidesJoined();

local p1Pos = GetUserPrefN("CoverPositionP1");
local p2Pos = GetUserPrefN("CoverPositionP2");

-- write fallbacks
if p1Pos == nil then
	SetUserPref("CoverPositionP1",0);
	p1Pos = GetUserPrefN("CoverPositionP1");
end;
if p2Pos == nil then
	SetUserPref("CoverPositionP2",0);
	p2Pos = GetUserPrefN("CoverPositionP2");
end;

local coverHeights = {
	PlayerNumber_P1 = p1Pos;
	PlayerNumber_P2 = p2Pos;
};

local positions = {
	PlayerNumber_P1 = {
		Singles = THEME:GetMetric("ScreenGameplay","PlayerP1OnePlayerOneSideX"),
		Doubles = THEME:GetMetric("ScreenGameplay","PlayerP1OnePlayerTwoSidesX"),
		Versus  = THEME:GetMetric("ScreenGameplay","PlayerP1TwoPlayersTwoSidesX"),
	},

	PlayerNumber_P2 = {
		Singles = THEME:GetMetric("ScreenGameplay","PlayerP2OnePlayerOneSideX"),
		Doubles = THEME:GetMetric("ScreenGameplay","PlayerP2OnePlayerTwoSidesX"),
		Versus  = THEME:GetMetric("ScreenGameplay","PlayerP2TwoPlayersTwoSidesX"),
	},
};

local function GetPosition(pn)
	if NumPlayers == 1 then
		-- one player, one side
		if NumSides == 1 then
			if IsUsingSoloSingles then return SCREEN_CENTER_X;
			else return positions[pn].Singles;
			end;
		-- one player, two sides
		elseif NumSides == 2 then
			return positions[pn].Doubles;
		end;

	elseif NumPlayers == 2 then
		-- two players, one side per player
		return positions[pn].Versus;
	end;
end;

function MakeCover(pn)
	local pname = playername(pn);
	local ret = Def.ActorFrame{
		Name="CoverP" .. pname;
	};

	local CoverItem;
	local IsDoubles = (NumPlayers == 1 and NumSides == 2);
	-- determine the setup so we know what type of cover to get.
	if IsDoubles then
		-- doubles
		CoverItem = LoadActor( THEME:GetPathG("_gameplay","covers/".. coverFile .."/8panel") );
	else
		-- one side.
		CoverItem = LoadActor( THEME:GetPathG("_gameplay","covers/".. coverFile .."/4panel") );
	end;

	ret[#ret+1] = CoverItem..{
		BeginCommand=function(self)
			if not getenv("ScreenCover"..pname) then
				self:visible(false);
				return;
			else
				self:visible(true);
			end;

			local coverAmount = 0;
			if GetUserPref("CoverPosition"..pname) then
				coverAmount = GetUserPrefN("CoverPosition"..pname);
			else
				-- make one
				SetUserPref( "CoverPosition"..pname, coverAmount );
			end;

			-- if the player is using reverse, cover from top and flip
			local mods = GAMESTATE:GetPlayerState(pn):GetPlayerOptions("ModsLevel_Preferred");
			if string.find(mods, "Reverse") then
				self:vertalign("VertAlign_Bottom");
				self:y( (SCREEN_TOP - SCREEN_HEIGHT) + coverAmount );
				self:zoomy(-1);
			else
				self:vertalign("VertAlign_Top");
				self:y( SCREEN_BOTTOM-coverAmount );
				self:zoomy(1);
			end;

			if IsDoubles then
				self:x( positions[pn].Doubles );
			else
				-- solo singles, regular singles, or versus?
				if IsUsingSoloSingles and NumPlayers == 1 then
					-- solo singles puts the player in the center,
					-- but only if there's one player.
					self:x( SCREEN_CENTER_X );
				elseif not IsUsingSoloSingles then
					-- now we need to check single or versus.
					if NumPlayers == 1 then
						self:x( positions[pn].Singles );
					elseif NumPlayers == 2 then
						self:x( positions[pn].Versus );
					end;
				end;
			end;
		end;
	};
	return ret;
end;

return Def.ActorFrame{
	MakeCover(PLAYER_1);
	MakeCover(PLAYER_2);
};